#ifdef __cplusplus
  extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "utilities.hpp"

const unsigned int sc08DB[] = {SCA, SCB, SCE, 0x08DB};
const unsigned int sc013A[] = {SCA, SCB, SCE, 0x013A};
const unsigned int sc0500[] = {SCA, SCB, SCE, 0x0500};
const unsigned int sc04E0[] = {SCA, SCB, SCE, 0x04E0};
const unsigned int sc04DF[] = {SCA, SCB, SCE, 0x04DF};
 
char* degreetodms(double deg, int decimal, char delimeter){
  int degree, minutes;
  double seconds;
  char* s; 
  char c;
  c = delimeter;
  s = (char*)malloc(14);
  degree = (int)deg;
  minutes = (int)((deg - (double)degree) * 60.0);
  seconds = ((deg - (double)degree - (double)minutes / 60.0) * 60.0 * 60.0);
  if (decimal < 1)
    sprintf((char*)s, (char*) "%d%c%d%c%2.0lf", degree, c, minutes, c, seconds);
  else if (decimal == 1)
    sprintf((char*)s, (char*) "%d%c%d%c%3.1lf", degree, c, minutes, c, seconds);
  else if (decimal == 2)
    sprintf((char*)s, (char*) "%d%c%d%c%4.2lf", degree, c, minutes, c, seconds);
  else if (decimal == 3)
    sprintf((char*)s, (char*) "%d%c%d%c%5.3lf", degree, c, minutes, c, seconds);
  else if (decimal == 4)
    sprintf((char*)s, (char*) "%d%c%d%c%6.4lf", degree, c, minutes, c, seconds);
  else if (decimal >= 5)
    sprintf((char*)s, (char*) "%d%c%d%c%7.5lf", degree, c, minutes, c, seconds);

  return s;
}

double parsedms(const char *s){
  int deg = 0, minute = 0, ns;
  double second = 0.0;
  char hemi;
  char s1[15], sc[15];
  int len;
  double degree;

  //degree = (double *)malloc(sizeof(double));
  len = strlen(s);
  strcpy(sc, s);
  sprintf(s1, "%s%c%s%c%s%s", "%d", 0x99, "%d", 0x99, "%lf", "%c");
  ns = sscanf(sc, s1, &deg, &minute, &second, &hemi);

  degree = (double)deg + (double)minute/60.0 + second/3600.0;
  if ((hemi == 0x53) || (hemi == 0x57))
    degree = -1 * (degree);
  return degree;
}

//Compute distance from given 2 points.
double calcDistance(double n1, double e1, double n2, double e2){
  double dist;
  //dist = (double*)malloc(sizeof(double));
  dist = sqrt((n1 - n2) * (n1 - n2) + (e1 - e2) * (e1 - e2));    
  return dist;
}

//Calculate azimuth from pt1 to pt2    
double calcAzimuth(double n1, double e1, double n2, double e2){
  //Compute Azimuth angle which giver 2 points and return in radian mode.
  double at2;
  double azimuth;

  //azimuth = (double*)malloc(sizeof(double));
  at2 = atan2(e2 - e1, n2 - n1);
  if (at2 < 0)
    azimuth = (at2 + 2 * PI); //return radian angle
  else
    azimuth = at2;
  return azimuth;  
}
 
//Input angles are radians.
double calcNextAzimuth(double currentang, double prevazi){
  double temp;
  //temp = (double*)malloc(sizeof(double));
  temp = currentang + prevazi;
  if (temp < PI)
    temp = temp + PI;
  else if (temp > 3 * PI)
    temp = temp - 3*PI;
  else
    temp = temp - PI;
   return temp;
}

//Input angle is radians.
double calcDiff2Angle(double angle2, double angle1){
  double temp;
  //temp = (double*)malloc(sizeof(double));
  temp = angle2 - angle1;
  if (temp < 0){
    temp = temp + 2*PI;
    return temp;
  }else
    return temp;
}
  
//Compute the intersection points which given 4 points.
// If intersection on line return point otherwise return None. 
int calcIntersectionFrom4Points(double n1, double e1, double n2, double e2, 
      double n3, double e3, double n4, double e4, double *ni, double *ei){

    double azimuth12, distance12, azimuth34, distance34;
    double dist1ni, dist2ni, dist3ni, dist4ni;
    int intersected;
    
    azimuth12 = calcAzimuth(n1, e1, n2, e2);
    distance12 = calcDistance(n1, e1, n2, e2);
    azimuth34 = calcAzimuth(n3, e3, n4, e4);
    distance34 = calcDistance(n3, e3, n4, e4);

    //print('++++ pt1 pt2 pt3 pt4 azimuth12 azimuth34 = ', pt1, pt2, pt3, pt4, azimuth12, azimuth34)

    if ((fabs(azimuth12) == (0.5 * PI)) || (fabs(azimuth12) == (1.5 * PI)))
	  *ni = n1;
    else if ((fabs(azimuth34) == (0.5 * PI)) || (fabs(azimuth34) == (1.5 * PI)))
      *ni = n3;
    else if (azimuth34 == azimuth12)
        return 0; //No intersection point
    else {
      *ni = (tan(azimuth34) * n3 - tan(azimuth12) * n1
                       + e1 - e3) / (tan(azimuth34) - tan(azimuth12));
      *ei = (*ni - n1) * tan(azimuth12) + e1;
    }    
    
    dist1ni = calcDistance(n1, e1, *ni, *ei);
    dist2ni = calcDistance(n2, e2, *ni, *ei);
    dist3ni = calcDistance(n3, e3, *ni, *ei);
    dist4ni = calcDistance(n4, e4, *ni, *ei);
    if ((fabs((dist1ni + dist2ni) - distance12) <= 0.0000000000001) 
      && (fabs((dist3ni + dist4ni) - distance34) <= 0.0000000000001)){
      intersected = 1;  //intersected
    }else 
      intersected = 0; //not intersected
   
    /*free(azimuth12);
    free(azimuth34);
    free(distance12);
    free(distance34);
    free(dist1ni);
    free(dist2ni);
    free(dist3ni);
    free(dist4ni);*/
    return intersected;
}


//Calc intersection point from 2 coordinate lines.
//Input Azimuth is radians.
int calcIntersectionAziAzi(double n1, double e1, double azimuth1, double n2, double e2, double azimuth2,
                           double *ni, double* ei){
    *ni = (tan(azimuth2) * n2 - tan(azimuth1) * n1
                   + e1 - e2) / (tan(azimuth2) - tan(azimuth1));
    *ei = (*ni - n1) * tan(azimuth1) + e1;
}

//Calc intersection point from azimuth (line) and distance (circle).
//input azimuth is radians.
int calcIntersectionAziDist(double n1, double e1, double azimuth1, double n2, double e2, double distance,
                            double *ni1, double* ei1, double *ni2, double *ei2){

    double phi1, phi2, azimuth12, distance12, distcheck;
    double azimuth2;
    int intersected;

    azimuth2 = calcNextAzimuth(azimuth1, 0.0); //reversed azimuth1
    distance12 = calcDistance(n1, e1, n2, e2);
    azimuth12 = calcAzimuth(n1, e1, n2, e2);
    phi1 = calcDiff2Angle(azimuth12, azimuth1);
    phi2 = calcDiff2Angle(azimuth12, azimuth2);

    distcheck = pow(distance, 2) - pow(distance12 * sin(phi1), 2);
    if (distcheck >= 0){
       *ni1 = (sqrt(pow(distance, 2) - pow(distance12 * sin(phi1), 2))
                     + distance12 * cos(phi1)) * cos(azimuth1) + n1;
       *ni2 = (sqrt(pow(distance, 2) - pow(distance12 * sin(phi2), 2))
                     + distance12 * cos(phi2)) * cos(azimuth2) + n1;
       *ei1 = (sqrt(pow(distance, 2) - pow(distance12 * sin(phi1), 2))
                     + distance12 * cos(phi1)) * sin(azimuth1) + e1;
       *ei2 = (sqrt(pow(distance, 2) - pow(distance12 * sin(phi2), 2))
                     + distance12 * cos(phi2)) * sin(azimuth2) + e1;
       intersected = 1;
    } else
       intersected = 0;
    /*free(distance12);
    free(azimuth12);
    free(phi1); 
    free(phi2);
    free(azimuth2);*/
    return intersected;
}

//Calc intersection points from 2 circles.
int calcIntersectionDistDist(double n1, double e1, double distance1, double n2, double e2, double distance2,
                             double *ni1, double *ei1, double *ni2, double *ei2){
    double distance12, angle, azimuth2I1, azimuth2I2, azimuth12;
    double angle1, angle2;
    int intersected;

    distance12 = calcDistance(n1, e1, n2, e2);
    azimuth12 = calcAzimuth(n1, e1, n2, e2);

    angle = acos((pow(distance2, 2) + pow(distance12, 2) - pow(distance1, 2)) / (2 * distance2 * distance12));
    angle1 = angle;
    angle2 = -1 * angle + 2*PI;

    azimuth2I1 = calcNextAzimuth(angle1, azimuth12);
    azimuth2I2 = calcNextAzimuth(angle2, azimuth12);

    if (distance12 < (distance1 + distance2)){
      *ni1 = n2 + distance2 * cos(azimuth2I1);
      *ei1 = e2 + distance2 * sin(azimuth2I1);
      *ni2 = n2 + distance2 * cos(azimuth2I2);
      *ei2 = e2 + distance2 * sin(azimuth2I2);
      intersected = 1; //intersected
    }else if (distance12 == (distance1 + distance2))
      intersected = -1; //tangency
    else if (distance12 > (distance1 + distance2))
      intersected = 0; // not intersected
    /*free(distance12);
    free(azimuth12);
    free(azimuth2I1);
    free(azimuth2I2);*/
}

int calcCircleCenter3D(double Ya, double Xa, double Za, 
                       double Yb, double Xb, double Zb, 
                       double Yc, double Xc, double Zc, 
                       double *YCen, double *XCen, double *ZCen, double *Radius){
    double AB, BC, AC;
    double ABi, ABj, ABk, ACi, ACj, ACk, CDi, CDj, CDk, Ni, Nj, Nk;
    double cosBAC, sinBAC;
    double AD, CD, Xd, Yd, Zd;
    double X2e, Y2e, Z2e;

	//if the two points are on the same coordinates stop and return.
    if (((Xa == Xb) && (Ya == Yb)) || ((Xa == Xc) && (Ya == Yc)) 
     || ((Xb == Xc) && (Yb == Yc)))
      return 0;

    //Xa = 80.779; Ya = 90.198; Za = 23.567;
    //Xb = 78.334; Yb = 66.990; Zb = 25.567;
    //Xc = 45.345; Yc = 67.623; Zc = 34.123;
    // Answer Radius = 21.778
    // N Center = 80.840, E Center = 61.890, Z Center = 29.037

    //Lengths of AB, AC, AC
    AB = sqrt(pow(Xa - Xb, 2) + pow(Ya - Yb, 2) + pow(Za - Zb, 2));
    BC = sqrt(pow(Xb - Xc, 2) + pow(Yb - Yc, 2) + pow(Zb - Zc, 2));
    AC = sqrt(pow(Xa - Xc, 2) + pow(Ya - Yc, 2) + pow(Za - Zc, 2));
    //Direction cosines of AB(ABi,ABj,ABk)
    ABi = (Xb - Xa) / AB;
    ABj = (Yb - Ya) / AB;
    ABk = (Zb - Za) / AB;
    //Direction cosines of AC(ACi,ACj,ACk)
    ACi = (Xc - Xa) / AC;
    ACj = (Yc - Ya) / AC;
    ACk = (Zc - Za) / AC;
    //Cosine of angle BAC
    cosBAC = (pow(AB, 2) + pow(AC, 2) - pow(BC, 2)) / (2 * AB * AC);
    AD = cosBAC * AC;
    CD = sqrt(pow(AC, 2) - pow(AD, 2));
    //Position of point D, which is C projected normally onto AB
    Xd = Xa + (AD * ABi);
    Yd = Ya + (AD * ABj);
    Zd = Za + (AD * ABk);
    //Direction cosines of CD(Cdi,CDj,CDk)
    CDi = (Xc - Xd) / CD;
    CDj = (Yc - Yd) / CD;
    CDk = (Zc - Zd) / CD;
    //Direction cosines of normal to AB and CD
    //to be used for rotations of circle centre
    Ni = (ABk * CDj) - (ABj * CDk);
    Nj = (ABi * CDk) - (ABk * CDi);
    Nk = (ABj * CDi) - (ABi * CDj);
    //# Diameter of circumscribed circle of a triangle is equal to the
    //the length of any side divided by sine of the opposite angle.
    //This is done in a coordinate system where X is colinear with AB, Y is // to CD,
    //and Z is the normal (N) to X and Y, and the origin is point A
    //  R = D / 2
    sinBAC = sqrt(1 - pow(cosBAC, 2));
    *Radius = (BC / sinBAC) / 2;
    //Centre of circumscribed circle is point E
    X2e = AB / 2;
    Y2e = sqrt((*Radius) * (*Radius) - X2e * X2e);
    Z2e = 0;
    //Transform matrix
    //                   Rotations                 Translations
    //           
    //              ABi  ,   ABj  ,  ABk                 Xa
    //              CDi  ,   CDj  ,  CDk                 Ya
    //               Ni  ,    Nj  ,   Nk                 Za
    //           
    //Position of circle centre in absolute axis system
    *XCen = Xa + (X2e * ABi) + (Y2e * CDi) + (Z2e * Ni);
    *YCen = Ya + (X2e * ABj) + (Y2e * CDj) + (Z2e * Nj);
    *ZCen = Za + (X2e * ABk) + (Y2e * CDk) + (Z2e * Nk);
    return 1;
}

int calcCircleCenter2D(double N1, double E1, double N2, double E2, 
                       double N3, double E3,
                       double *Nc, double *Ec, double *Radius){
    double midN12, midE12, midN23, midE23;
    double k, l, p, q, r, s;
    
    //1 23.432m 78.234m
    //2 45.323m 98.765m
    //3 67.334m 66.999m
    //Answer R=22.907, N Center = 75.876, E Center = 46.217

    if (((N2 == N1) && (E2 == E1)) ||
       ((N2 == N3) && (E2 == E3)) ||
       ((N1 == N3) && (E1 == E3)))
      return 0;

    midN12 = (N1 + N2) / 2.0;
    midE12 = (E1 + E2) / 2.0;
    midN23 = (N2 + N3) / 2.0;
    midE23 = (E2 + E3) / 2.0;


    k = atan((E2-E1)/(N2-N1)) + PI / 2.0;
    l = atan((E2-E3)/(N2-N3)) + PI / 2.0;
    p = 1.0 / tan(k);
    q = 1.0 / tan(l);
    r = tan(k);
    s = tan(l);
    *Ec = ((midE23*q)-(midE12*p)+midN12-midN23)/(q-p);
    *Nc = ((midN23*s)-(midN12*r)+midE12-midE23)/(s-r);
    *Radius = sqrt((E1-*Ec)*(E1-*Ec) + (N1-*Nc)*(N1-*Nc));
    return 1;
}

//Input left HA and right HA are radians.
int calcCircleCenter2Ang1Dist(double NSta, double ESta, double NBS, double EBS,
                              double leftang, double rightang, double dist,
                              double *NCenter, double *ECenter, double *Radius){
      
    double azi12, azi23, azi24, azi2c;
    double midang, halfang;

    if (leftang == rightang)
      return 0;
    if ((NBS == NSta) && (EBS == ESta))
      return 0;
    if (dist == 0)
      return 0;
    azi12 = calcAzimuth(NBS, EBS, NSta, ESta);
    azi23 = calcNextAzimuth(leftang, azi12);

    azi24 = calcNextAzimuth(rightang, azi12);

    halfang = calcDiff2Angle(azi24, azi23) / 2.0;
    azi2c = calcNextAzimuth(halfang + leftang, azi12);
    *Radius = dist * sin(halfang) / (1 - sin(halfang));
    *ECenter = (dist + *Radius) * sin(azi2c) + ESta;
    *NCenter = (dist + *Radius) * cos(azi2c) + NSta;
    return 1;

    // Example 
    // Station N=2640000.032 E=251443.840
    // BS N=2639964.657 E=251446.586
    // Left HA 92-31-2.59 and Rigth HA 101-7-24.09
    // Dist = 8.039
    // Answer N Center = 2639964.296 E Center = 251455.270
    // Radius 0.652
}


void GetAlphaDoubleData(char alpha, double *dval){
  TBCD *bcd;
  TBCDvalue *bval;
  //double dval;
  int i, ii;

  bval = (TBCDvalue *)malloc(sizeof(TBCDvalue));
  Alpha_GetData(alpha, bval);
  bcd = new TBCD;
  i = bcd->Set(*bval);
  ii = bcd->Get(*dval);
  delete bcd;
  free(bval);
}

void SetAlphaDoubleData(char alpha, double dval){
  TBCD *bcd;
  TBCDvalue bval;
  int i, ii;

  bcd = new TBCD;
  i = bcd->Set(dval);
  ii = bcd->Get(bval);
  Alpha_SetData(alpha, &bval);
  delete bcd;
}


//
TBCDvalue*TBCD::PValue(){
  return FValue;
};

//
int TBCD::Get( TBCDvalue&value ){
int result = 0;
  memcpy( &value, &FValue, sizeof( TBCDvalue ) );
  return result;
};

//
int TBCD::Set( TBCDvalue&value ){
int result = 0;
  memcpy( &FValue, &value, sizeof( TBCDvalue ) );
  return result;
};

//
int TBCD::Set( double&value ){
int result=0;
double dwork;
double dwork2;
int iexponent;
int i;
  memset( FValue, 0, sizeof( TBCDvalue ) );
  iexponent = 100;
  dwork = value;
  if ( dwork < 0 ){ 
        iexponent += 500;
        dwork = -dwork;
  };
  while ( dwork >= 10 ){
        iexponent+=1;
        dwork = dwork / 10;
  };
  while ((dwork > 0) && (dwork < 1)){ //Bugs fixed by PBR
        iexponent-=1;
        dwork = dwork * 10;
  };
  FValue[0].exponent = ( iexponent / 100 );
  iexponent = iexponent - ( iexponent / 100 ) * 100;
  FValue[0].exponent <<= 4;
  FValue[0].exponent += ( iexponent / 10 );
  FValue[0].exponent <<= 4;
  iexponent = iexponent - ( iexponent / 10 ) * 10;
  FValue[0].exponent += iexponent; 
 
  dwork = modf( dwork, &dwork2 ) * 10;
  FValue[0].mantissa0 = floor( dwork2 );
  for ( i = 0; i < 7;i++ ){
        dwork = modf( dwork, &dwork2 ) * 10;
        FValue[0].mantissa[i].hnibble = dwork2;
        dwork = modf( dwork, &dwork2 ) * 10;
        FValue[0].mantissa[i].lnibble = dwork2;
  }

  return result;
};

//
int TBCD::Get( double&value ){
int result=0;
int i;
double factor = 1;
TBCDInternal work;

  BCDtoInternal(&work, FValue);  
  value = work.mantissa[0];
  for (i=1;i<15;i++){ 
        factor /= 10;
        if (work.mantissa[i]){ value += factor * work.mantissa[i]; };
  };
  while ( work.exponent++ < 0 ){ value /= 10;};
  while ( --work.exponent > 0 ){ value *= 10;};
  value *= work.sign;
  
  return result;
};

//
int TBCD::SetError( int error ){
int result=(FValue[0].exponent & 0xF00)>>4;
  FValue[0].exponent = ( FValue[0].exponent & 0xFF ) | ( error << 4 );
  return result;
};

//
int TBCD::GetError(){
int result=(FValue[0].exponent & 0xF00)>>4;
  return result;
};

//
void TBCD::Swap(){
TBCDvalue work;
  FValue[0] = FValue[1];
  FValue[1] = work;
};

 #ifdef __cplusplus
}
  #endif