/***************************************************************************/
/*
 *                              FUNCTION PROTOTYPES
 *                                for utilities.cpp
 */
/* ensure proper linkage to c++ programs */
  #ifdef __cplusplus
extern "C" {
  #endif

#define SCA 0xD201D002
#define SCB 0x422B0009
#define SCE 0x80010070
#define PI 3.14159265358979323846
#define DEG2RAD PI/180.0
#define RAD2DEG 180.0/PI

typedef struct{
  unsigned char hnibble:4;
  unsigned char lnibble:4;
} TBCDbyte;

typedef struct{
  unsigned short exponent:12;
  unsigned short mantissa0:4;
  TBCDbyte mantissa[7];
  char flags;
  short info;
} TBCDvalue;

typedef struct{
  int exponent;
  int sign;
  int unknown; 
  char mantissa[15];
} TBCDInternal;

class TBCD{
  public:
        TBCDvalue*PValue();
        int Get( TBCDvalue&value );
        int Set( TBCDvalue&value );
        int Set( double&value );
        int Get( double&value );
        int SetError( int error );
        int GetError();
        void Swap();
  protected:
  private:
        TBCDvalue FValue[2];
};

extern const unsigned int sc08DB[];
extern const unsigned int sc013A[];
extern const unsigned int sc0500[];
extern const unsigned int sc04DF[];
extern const unsigned int sc04E0[];

typedef int(*sc_EE)(int, short, int, char*, char*, short, char*, int );
typedef void(*sc_vi)(int);
typedef int(*sc_BCDToIn)(TBCDInternal *, TBCDvalue *);
typedef void(*sc_agd)(char, TBCDvalue*);
typedef void(*sc_asd)(char, TBCDvalue*);

#define EditExpression (*(sc_EE)sc08DB) 
#define Cursor_SetFlashMode (*(sc_vi)sc013A)
#define BCDtoInternal (*(sc_BCDToIn)sc0500)
#define Alpha_GetData (*(sc_agd)sc04DF)
#define Alpha_SetData (*(sc_asd)sc04E0)

void GetAlphaDoubleData(char alpha, double *dval);
void SetAlphaDoubleData(char alpha, double val);


//delimeter 0x2D for PrintLine(), Print() and 0x99 for EditExpression()
char* degreetodms(double deg, int decimal, char delimeter); 
double parsedms(const char *s);
double calcDistance(double n1, double e1, double n2, double e2);
double calcAzimuth(double n1, double e1, double n2, double e2);
double calcNextAzimuth(double currentang, double prevazi);
double calcDiff2Angle(double angle2, double angle1);
int calcIntersectionFrom4Points(double n1, double e1, double n2, double e2, 
                                double n3, double e3, double n4, double e4, double *ni, double *ei);
int calcIntersectionAziAzi(double n1, double e1, double azimuth1, double n2, double e2, double azimuth2,
                           double *ni, double* ei);
int calcIntersectionAziDist(double n1, double e1, double azimuth, double n2, double e2, double distance,
                            double *ni1, double*ei1, double *ni2, double *ei2);
int calcIntersectionDistDist(double n1, double e1, double distance1, double n2, double e2, double distance2,
                             double *ni1, double *ei1, double *ni2, double *ei2);
int calcCircleCenter3D(double Ya, double Xa, double Za, 
                       double Yb, double Xb, double Zb, 
                       double Yc, double Xc, double Zc, 
                       double *YCen, double *XCen, double *ZCen, double *Radius);
int calcCircleCenter2D(double N1, double E1, double N2, double E2, 
                       double N3, double E3,
                       double *Nc, double *Ec, double *Radius);
int calcCircleCenter2Ang1Dist(double NSta, double ESta, double NBS, double EBS,
                              double leftang, double rightang, double dist,
                              double *NCenter, double *ECenter, double *Radius);


  #ifdef __cplusplus
}
  #endif

