from pbrutils import split_angle,deg2dms,DMS2str
from pbrutils import calcAzimuth,calcDistance,calcDiff2Angle
from pbrutils import calcNextAzimuth,calcNextCoordinate2D
from pbrutils import calcNextCoordinate3D
from pbrutils import PI,DEG2RAD,RAD2DEG,clear
import math
 
def print_menu():
  print('COGO Selected Serie 1')
  print('1: Bearing-Dist(2pt)')
  print('2: Bearing-Dist(3pt)')
  print('3: Coordinate 2D')
  print('4: Coordinate 3D')
  print('5: Exit')

def bearing_dist_2pt():
  nbs=float(input("N-BS=" ))
  ebs=float(input("E-BS=" ))
  nin=float(input("N-Instr=" ))
  ein=float(input("E-Instr=" ))
  azi21=calcAzimuth(nin,ein,nbs,ebs)
  dist21=calcDistance(nin,ein,nbs,ebs)
  dazi21=azi21*RAD2DEG
  print(6*'-',"Output",6*'-')
  print("Instrument => BS")
  sn,d,m,s=deg2dms(dazi21)
  st=DMS2str(d,m,s,2)
  print("Azimuth=",st) 
  print("Dist=","{0:.3f} m".format(dist21)) 
  input("Press EXE key")  

def bearing_dist_3pt():
  nbs=float(input("N-BS=" ))
  ebs=float(input("E-BS=" ))
  nin=float(input("N-Instr=" ))
  ein=float(input("E-Instr=" ))
  nfs=float(input("N-FS=" ))
  efs=float(input("E-FS=" ))
  azi21=calcAzimuth(nin,ein,nbs,ebs)
  dist21=calcDistance(nin,ein,nbs,ebs)
  azi23=calcAzimuth(nin,ein,nfs,efs)
  dist23=calcDistance(nin,ein,nfs,efs)
  dazi21=azi21*RAD2DEG
  dazi23=azi23*RAD2DEG
  print(6*'-',"Output",6*'-')
  print("Instrument => BS")
  sn,d,m,s=deg2dms(dazi21)
  st=DMS2str(d,m,s,2)
  print("Azimuth=",st) 
  print("Dist=","{0:.3f} m".format(dist21)) 
  input("Press EXE key")
  print("Instrument => FS")
  sn,d,m,s=deg2dms(dazi23)
  st=DMS2str(d,m,s,2)
  print("Azimuth=",st) 
  print("Dist=","{0:.3f} m".format(dist23)) 
  hang=RAD2DEG*calcDiff2Angle(azi23,azi21)
  sn,d,m,s=deg2dms(hang)
  st=DMS2str(d,m,s,2)
  print("H Angle=",st)  
  input("Press EXE key")  
  
def cooordinate2D():
  nbs=float(input("N-BS=?"))
  ebs=float(input("E-BS=?"))
  nin=float(input("N-Instr=?"))
  ein=float(input("E-Instr=?"))
  ang=input("H Angle=?")
  hang=split_angle(ang)*DEG2RAD
  grndist=float(input("Ground Dist=?"))
  sf=float(input("SF=?"))
  grddist=sf*grndist
  azi12=calcAzimuth(nbs,ebs,nin,ein)
  azi21=calcAzimuth(nin,ein,nbs,ebs)
  dist21=calcDistance(nin,ein,nbs,ebs)  
  nt,et=calcNextCoordinate2D(nin,ein,azi12,hang,grddist)
  azi23=calcNextAzimuth(hang,azi12) 
  print(6*'-',"Output",6*'-') 
  print("Instrument => BS")
  sn,d,m,s=deg2dms(azi21*RAD2DEG)
  st=DMS2str(d,m,s,2)
  print("Azimuth=",st)
  print("Grd Dist=","{0:.3f} m".format(dist21)) 
  print("Instrument => FS")
  sn,d,m,s=deg2dms(azi23*RAD2DEG)
  st=DMS2str(d,m,s,2)
  print("Azimuth=",st) 
  print("Gnd Dist=","{0:.3f} m".format(grndist)) 
  print("Grd Dist=","{0:.3f} m".format(grddist)) 
  input("Press EXE key") 
  print("N=","{0:.3f} m".format(nt))
  print("E=","{0:.3f} m".format(et))
  input("Press EXE key") 

def cooordinate3D():
  nbs=float(input("N-BS=?"))
  ebs=float(input("E-BS=?"))
  nin=float(input("N-Instr=?"))
  ein=float(input("E-Instr=?"))
  ele=float(input("Elev=?"))
  hi=float(input("HI=?"))
  ang=input("H Angle=?")
  hang=split_angle(ang)*DEG2RAD
  ang=input("V Angle=?")
  vang=split_angle(ang)*DEG2RAD
  sgrndist=float(input("Slope Dist=?"))
  sf=1.0
  sf=float(input("SF=?"))
  if sf<1.0:
    sf=1.0
  sgrddist=sgrndist*sf
  ht=float(input("HT=?"))
  azi21=calcAzimuth(nin,ein,nbs,ebs)
  azi12=calcAzimuth(nbs,ebs,nin,ein)
  dist21=calcDistance(nin,ein,nbs,ebs)
  azi23=calcNextAzimuth(hang,azi12)
  nt,et,zt=calcNextCoordinate3D(nin,ein,ele,azi12,hang,vang,sgrddist,hi,ht)
  print(6*'-',"Output",6*'-') 
  print("Instrument => BS")
  sn,d,m,s=deg2dms(azi21*RAD2DEG)
  st=DMS2str(d,m,s,2)
  print("Azimuth=",st)
  print("Grd Dist=","{0:.3f} m".format(dist21)) 
  print("Instrument => FS")
  sn,d,m,s=deg2dms(azi23*RAD2DEG)
  st=DMS2str(d,m,s,2)
  print("Azimuth=",st) 
  input("Press EXE key") 
  print("S Gnd Dist= {0:.3f} m".format(sgrndist)) 
  print("S Grd Dist= {0:.3f} m".format(sgrddist)) 
  print("H Gnd Dist= {:.3f} m".format(sgrndist*math.sin(vang)))
  print("H Grd Dist= {:.3f} m".format(sgrddist*math.sin(vang)))
  print("Height diff= {:.3f} m".format(zt-ele))
  input("Press EXE key")
  print("N=","{0:.3f} m".format(nt))
  print("E=","{0:.3f} m".format(et))  
  print("Elev=","{0:.3f} m".format(zt)) 
  input("Press EXE key") 
  
loop=True
choice=-1
ex_choice=-1
while loop:      
  print_menu()
  choice=int(input('Selection[1-5]'))  
  if (choice==5):
    loop=False
  elif (choice==1):
    loop=True
    bearing_dist_2pt()
    ex_choice=1
  elif (choice==2):
    loop=True
    bearing_dist_3pt()
    ex_choice=2
  elif (choice==3):
    cooordinate2D()
    loop=True
    ex_choice=3
  elif (choice==4):
    loop=True
    cooordinate3D()
    ex_choice=4