from pbrutils import split_angle,deg2dms,DMS2str
from pbrutils import calcAzimuth,calcDistance,calcDiff2Angle
from pbrutils import calcNextAzimuth,calcNextCoordinate2D
from pbrutils import calcNextCoordinate3D
from pbrutils import PI,DEG2RAD,RAD2DEG,mean
import math

MAXITERATIONS = 256
TOLERANCE = 1e-06

def print_menu():
  print('COGO Selected Serie 2')
  print('1:Center Circle(1Pt)')
  print('2:Center Circle(2pt)')
  print('3:Center Circle(3pt)')
  print('4:Center Circle(>3pt)')
  print('5:Exit')

def center_circle_1pt():
  nbs=float(input("N-BS=?" ))
  ebs=float(input("E-BS=?" ))
  nin=float(input("N-Instr=?" ))
  ein=float(input("E-Instr=?" ))
  ang1=input("Lt H Angle=?")
  hang1=split_angle(ang1)*DEG2RAD 
  ang2=input("Rt H Angle=?")
  hang2=split_angle(ang2)*DEG2RAD 
  hang=hang2-hang1 if hang2-hang1>=0 else 2*math.pi+hang2-hang1
  theta = hang/2.0
  print("Point to mid angle.")
  azi12=calcAzimuth(nbs,ebs,nin,ein)
  midhang=hang1+theta if hang1+theta<2*math.pi else hang1+theta-2*math.pi
  sn,d,m,s=deg2dms(midhang*RAD2DEG)
  st=DMS2str(d,m,s,2)
  print("Mid Angle=",st) 
  hdist=float(input("H distance=?"))
  radius=(math.sin(theta)*hdist)/(1-math.sin(theta))
  print("Radius={0:.3f} m".format(radius))
  nc,ec=calcNextCoordinate2D(nin,ein,azi12,midhang,hdist+radius)
  print("N Center=","{0:.3f} m".format(nc))
  print("E Center=","{0:.3f} m".format(ec))
  input("Press EXE key")  

def center_circle_2pt():
  print("Enter known 2 points.")
  n1=float(input("N1=?" ))
  e1=float(input("E1=?" ))
  n2=float(input("N2=?" ))
  e2=float(input("E2=?" ))
  r=float(input("Radius=?"))
  q=math.sqrt((e2-e1)**2+(n2-n1)**2)
  e3=(e1+e2)/2.0
  n3=(n1+n2)/2.0
  ec1=e3+math.sqrt(r**2-(q/2.0)**2)*(n1-n2)/q
  nc1=n3+math.sqrt(r**2-(q/2.0)**2)*(e2-e1)/q
  ec2=e3-math.sqrt(r**2-(q/2.0)**2)*(n1-n2)/q
  nc2=n3-math.sqrt(r**2-(q/2.0)**2)*(e2-e1)/q
  print("First circle:")
  print("NC=","{0:.3f} m".format(nc1))
  print("EC=","{0:.3f} m".format(ec1))
  print("Second circle:")
  print("NC=","{0:.3f} m".format(nc2))
  print("EC=","{0:.3f} m".format(ec2))
  input("Press EXE key")  
  
def center_circle_3pt():
  print("Enter known 3 points.")
  y1=float(input("N1=?" ))
  x1=float(input("E1=?" ))
  y2=float(input("N2=?" ))
  x2=float(input("E2=?" ))
  y3=float(input("N3=?" ))
  x3=float(input("E3=?" ))
  v_dA = x2 - x1
  v_dB = y2 - y1
  v_dC = x3 - x1
  v_dD = y3 - y1
  v_dE = v_dA * (x1 + x2) + v_dB * (y1 + y2)
  v_dF = v_dC * (x1 + x3) + v_dD * (y1 + y3)
  v_dG = 2.0  * (v_dA * (y3 - y2) - v_dB * (x3 - x2))
  # If v_dG is zero then the three points are collinear and no finite-radius
  # circle through them exists.
  if (v_dG == 0):
    print("3 pts are collinear.")
    print("Cannot solve!!!")
  else:
    xc = (v_dD * v_dE - v_dB * v_dF) / v_dG
    yc = (v_dA * v_dF - v_dC * v_dE) / v_dG
    radius = math.sqrt((x1-xc)**2 + (y1-yc)**2)
  print("Center of Circle:")
  print("N= {0:.3f} m".format(yc))
  print("E= {0:.3f} m".format(xc))
  print("Radius= {0:.3f} m".format(radius))
  print("Diameter= {:.3f} m".format(2*radius))
  input("Press EXE key") 

def circlefit_leastsquares():
  num=int(input("How many points?"))
  ns=[]
  es=[]
  for i in range(num):
    ns.append(float(input("N{:n}=?".format(i+1))))
    es.append(float(input("E{:n}=?".format(i+1))))
  x_m=mean(es)
  y_m=mean(ns)
    
  a=x_m
  b=y_m
  for i in range(MAXITERATIONS):
    a0=a
    b0=b
    # compute average L, dL/da, dL/db 
    LAvr=0.0
    LaAvr=0.0
    LbAvr=0.0
    for x,y in zip(es,ns):
      dx=x - a
      dy=y - b
      L=math.sqrt(dx**2 + dy**2)
      if (abs(L) > TOLERANCE):
        LAvr+=L
        LaAvr-=dx / L
        LbAvr-=dy / L
    LAvr/=num;
    LaAvr/=num;
    LbAvr/=num;

    a=x_m + LAvr * LaAvr
    b=y_m + LAvr * LbAvr
    r=LAvr

    if (abs(a - a0) <= TOLERANCE and abs(b - b0) <= TOLERANCE):
      break
  if (i < MAXITERATIONS):    
    print("Iterations= {:n}".format(i+1))
    print("Circle center:")
    print("N= {0:.4f} m".format(b))
    print("E= {0:.4f} m".format(a)) 
    print("Radius= {0:.4f} m".format(r))
    print("Diameter= {:.4f} m".format(2*r))
  else:
    print("Cannot find solution!!!")
  input("Press EXE key") 

loop=True
choice=-1
ex_choice=-1
while loop:      
  print_menu()
  choice=int(input('Selection[1-5]'))  
  if (choice==5):
    loop=False
  elif (choice==1):
    loop=True
    center_circle_1pt()
    ex_choice=1
  elif (choice==2):
    loop=True
    center_circle_2pt()
    ex_choice=2
  elif (choice==3):
    center_circle_3pt()
    loop=True
    ex_choice=3
  elif (choice==4):
    loop=True
    circlefit_leastsquares()
    ex_choice=4