from pbrutils import split_angle,deg2dms,DMS2str
from pbrutils import calcAzimuth,calcDistance,calcDiff2Angle
from pbrutils import calcNextAzimuth
from pbrutils import calcIntersectionAzimuthAzimuth,equation_plane
from pbrutils import PI,DEG2RAD,RAD2DEG,mean,calcNextCoordinate2D
from pbrutils import isect_line_plane_v3_4d
from pbrutils import calcExtend3DLineCoords,area_by_shoelace
import math

def print_menu():
  print('COGO Selected Serie 4')
  print('1:Ext Line to Plane')
  print('2:Ext Pt from 3D Line')
  print('3:Calculate Area')
  print('4:Mark Axis')
  print('5:Exit')

def extend_line_to_plane():
  print('Extend Line to Plane:')
  print("Input Line:")
  #n1,e1,z1=1.0,4.0,1.0
  n1=float(input("N1=?"))
  e1=float(input("E1=?"))
  z1=float(input("Z1=?"))
  #n2,e2,z2=-2.0,8.0,-2.0
  n2=float(input("N2=?"))
  e2=float(input("E2=?"))
  z2=float(input("Z2=?"))
  print("Input 3 pts of Plane:")
  #n3,e3,z3=2.0,-1.0,4.0
  n3=float(input("N3=?"))
  e3=float(input("E3=?"))
  z3=float(input("Z3=?"))
  #n4,e4,z4=1.0,2.0,3.0
  n4=float(input("N4=?"))
  e4=float(input("E4=?"))
  z4=float(input("Z4=?"))
  #n5,e5,z5=3.0,1.0,2.0
  n5=float(input("N5=?"))
  e5=float(input("E5=?"))
  z5=float(input("Z5=?"))
  a,b,c,d=equation_plane(n3,e3,z3,n4,e4,z4,n5,e5,z5)
  plane=[a,b,c,d]
  pi,ang=isect_line_plane_v3_4d([e1,n1,z1],[e2,n2,z2],plane)
  if pi:
    print("Intersection point:")
    print("N= {0:.3f}".format(pi[1]))
    print("E= {0:.3f}".format(pi[0]))
    print("Z= {0:.3f}".format(pi[2]))
    print("Angle: {:.7f} deg".format(ang*RAD2DEG))
  else:
    print("Not intersect plane!")
  input("Press any key")  

def extend_point_from_3Dline():
  print("Ext point from 3D line.")
  print("Input Line:")
  n1=float(input("N1=?"))
  e1=float(input("E1=?"))
  z1=float(input("Z1-?"))
  n2=float(input("N2=?"))
  e2=float(input("E2=?"))
  z2=float(input("Z2=?"))
  print("Input extend distance:")
  ext=float(input("Extend dist=?"))
  n3,e3,z3=calcExtend3DLineCoords(n1,e1,z1,n2,e2,z2,ext)
  print("Ext pt coordinates:")
  print("N= {:.3f}".format(n3))
  print("E= {:.3f}".format(e3))
  print("Z= {:.3f}".format(z3))
  input("Press any key") 

def calculate_area():
  pts=[]
  i=1
  print("Calculate area.")
  print("Input points:")
  n0=float(input("N1=?" ))
  e0=float(input("E1=?" ))
  pts.append((n0,e0))
  x0,y0=e0,n0
  f = True
  while f:
    y=float(input("N{}=?".format(i+1)))
    x=float(input("E{}=?".format(i+1)))
    pts.append((y,x))
    if (i>2):
      if (x==x0) and (y==y0):
        f=False
    i+=1    
  y,x=zip(*pts)   
  area=area_by_shoelace(x,y)
  print("Result of calculation:")
  print("Area= {:0.3f}".format(area))
  input("Press any key") 

def mark_axis():
  f=True
  print("Mark Axis.")
  print("Input Design:")
  nde=float(input("N=?" ))
  ede=float(input("E=?" ))
  az1=input("Azimuth=?")
  azi1=split_angle(az1)*DEG2RAD 
  while f:
    print("Input Actual:")
    nac=float(input("N=?" ))
    eac=float(input("E=?" )) 
    azide2ac=calcAzimuth(nde,ede,nac,eac)
    dist=calcDistance(nde,ede,nac,eac)
    print("Dist= {:.3f}".format(dist))
    print("Deviated:")
    print("NE: {:.3f} {:.3f}".format(nac-nde,eac-ede))
    xy1=dist*math.cos(azide2ac-azi1)
    xy2=dist*math.sin(azide2ac-azi1)
    print("YX: {:.3f} {:.3f}".format(xy1,xy2))
    print("Total {:.3f}".format(dist))
    con=input("Continue (Y/N)?")
    if con=="Y" or con=="y":
      f=True
    else:
      f=False

loop=True
choice=-1
ex_choice=-1
while loop:      
  print_menu()
  choice=int(input('Selection[1-5]'))  
  if (choice==5):
    loop=False
  elif (choice==1):
    loop=True
    extend_line_to_plane()
    ex_choice=1
  elif (choice==2):
    loop=True
    extend_point_from_3Dline()
    ex_choice=2
  elif (choice==3):
    calculate_area()
    loop=True
    ex_choice=3
  elif (choice==4):
    loop=True
    mark_axis()
    ex_choice=4